package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.entity.EntityModifiable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class GeneSpeedIncrease extends Gene{

	public GeneSpeedIncrease(int id) {
		super(id);
	}

	@Override
	public String getName() {
		return "Speed Increase";
	}
	
	@Override
	public String getStringValue(int amount) {
		return amount*100 + "% Speed Increase";
	}

	@Override
	public int getMaxAmount() {
		return 2;
	}

	@Override
	public int getColour() {
		return 0xff33dbf9;
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{EntitySpider.class, EntityHorse.class};
	}

	public void addGeneEffect(EntityLivingBase entity, int level){
		entity.addPotionEffect(new PotionEffect(Potion.moveSpeed.id, Integer.MAX_VALUE, level));
	}
	
	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		if(!entity.isPotionActive(Potion.moveSpeed.id)){
			entity.addPotionEffect(new PotionEffect(Potion.moveSpeed.id, Integer.MAX_VALUE, level));
		}
	}

	
	

}
